/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Web controls                     }
{ Copyright (c) 2003, 2004 Borland Software Corporation }
{                                                       }
{*******************************************************/

using System;
using System.Data;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.ComponentModel.Design.Serialization;
using System.Drawing;
using System.Drawing.Design;
using System.Text;



namespace Borland.Data.Web
{
	/// <summary>
	/// Data aware Calendar control.  Connects to a Date or timestamp field,
   /// lets DBWebDataSource handle changes.
	/// </summary>
   #region DBWebCalendar
	[Designer("Borland.Data.Web.DBWebCalendarDesigner"),
   ToolboxBitmap(typeof(Borland.Data.Web.DBWebCalendar),
   "Borland.Data.Web.DBWebCalendar.bmp"),
	ToolboxData("<{0}:DBWebCalendar runat=server></{0}:DBWebCalendar>")]
   public class DBWebCalendar : Calendar, IDBWebColumnLink, IPostBackDataHandler
   {
      private IDBWebColumnLink IColumnLink;
      private DBWebColumnLink FColumnLink;


   	public DBWebCalendar() : base()
      {
      	FColumnLink = new DBWebColumnLink(this);
         IColumnLink = FColumnLink as IDBWebColumnLink;
      }

		protected override void OnInit(EventArgs e)
		{
			base.OnInit(e);
			if( Page != null )
				Page.RegisterRequiresPostBack(this);
		}

		protected override void OnPreRender(EventArgs args)
		{
			base.OnPreRender(args);
			string s = Page.Request.QueryString[DBWebConst.sBorlandImageID];
         if( s != null )
         	return;
         DataBind();
         Page.RegisterHiddenField(DBWebDataSource.IdentPrefix + this.ID, IColumnLink.TableName + DBWebConst.Splitter + IColumnLink.ColumnName);
		}

      #region IPostBackDataHandler

      // RaisePostDataChangedEvent is called prior to DataBind()
      // DataSet and related properties are NOT available here
      // Child controls are not available
		bool IPostBackDataHandler.LoadPostData(string postDataKey,
			NameValueCollection postCollection)
      {
         if( this.Visible )
         {
	         FColumnLink.LoadPostData(postDataKey, postCollection);
   	      FColumnLink.LoadCalendarColumn(postCollection);
         }
        	return false;
      }

	   void IPostBackDataHandler.RaisePostDataChangedEvent()
   	{
      // RaisePostDataChangedEvent is called after DataBind(),
      // so DataBind() cannot depend on anything done here.
      // DataSet and related properties ARE available here
      // Child controls are NOT available
	   }

      #endregion

      #region IDBWebDataLink
      string IDBWebDataLink.TableName
      {
      	get
         {
         	return IColumnLink.TableName;
         }
         set
         {
         	IColumnLink.TableName = value;
         }
      }
      IDBDataSource IDBWebDataLink.DBDataSource
      {
      	get
         {
         	return IColumnLink .DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }
      #endregion
      #region IDBWebColumnLink
      string IDBWebColumnLink.ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
         	IColumnLink.ColumnName = value;
         }
      }
      #endregion

      [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
      [LocalizableDescriptionAttribute("TableName")]
      public string TableName
      {
      	get
         {
	      	return IColumnLink.TableName;
         }
      	set
         {
	      	IColumnLink.TableName = value;
         }
      }
		[LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
		DefaultValue(null)]
      [LocalizableDescriptionAttribute("DataSource")]
      public IDBDataSource DBDataSource
      {
      	get
         {
         	return IColumnLink.DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }


	  [Editor(typeof(Borland.Data.Web.DateTimeColumnPropEditor), typeof(UITypeEditor)),
	   LocalizableCategoryAttribute(DBTypes.sDBWebControl),
	   DefaultValue(null)]
      [LocalizableDescriptionAttribute("ColumnName")]
      public string ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
         	IColumnLink.ColumnName = value;
         }
      }

  		protected override void Render(HtmlTextWriter output)
		{
      	bool error = ClassUtils.OutputErrors(Page, output, IColumnLink);
         if( !error || (IColumnLink.DBDataSource as DBWebDataSource).ErrorOption != ErrorHtmlOption.logOnErrorPage )
         	base.Render(output);
         else  // if going to a separate error hmtl page, output "OK" button.
         {
         	ClassUtils.OutputOKButton(output);
            Page.Response.End();
         }
		}

		public override void DataBind()
      {
      	try
         {
	         base.DataBind();
   	      if( ClassUtils.IsDesignTime(Page) && !FColumnLink.IsDataBound )
      		{
         		this.SelectedDate = DateTime.MinValue;
            	this.VisibleDate = DateTime.Now;
   	      }
	         if( FColumnLink.IsDataBound )
      	   {
         		Object o = IColumnLink.DBDataSource.GetColumnValue(Page,
            						IColumnLink.TableName, IColumnLink.ColumnName);
	   	      if( o != null )
   	         {
      	         this.SelectedDate = Convert.ToDateTime(o);
         	      this.VisibleDate = this.SelectedDate;
            	}
	         	base.DataBind();
   	   	}
         }
         catch(Exception ex)
         {
         	if( !ClassUtils.IsDesignTime(Page) )
            {
	            Page.Response.Write(ClassUtils.GetInternalError(Page, IColumnLink, ex, this.ID));
            }
            else
            	throw new Exception(ex.Message);
         }
      }
	}
   #endregion


}
